<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Gateapp\Models\Flat;
use Vtlabs\Gateapp\Models\Project;
use Vtlabs\Gateapp\Filters\FlatFilter;
use Vtlabs\Gateapp\Filters\ProjectFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Http\Resources\ProjectResource;
use Vtlabs\Gateapp\Http\Resources\ProjectDirectoryResource;

class ProjectController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'pagination' => 'sometimes|boolean',
            'title' => 'sometimes|string'
        ]);

        $projects = Project::filter($request->all(), ProjectFilter::class);

        if ($request->pagination == '0') {
            $projects = $projects->get();
        } else {
            $projects = $projects->paginate();
        }

        return ProjectResource::collection($projects);
    }

    public function directory(Project $project, Request $request)
    {
        $request->validate([
        ]);

        $request->merge([
            'project_id' => $project->id
        ]);

        $flats = Flat::with('residents')->filter($request->all(), FlatFilter::class)->orderBy('title');

        return ProjectDirectoryResource::collection($flats->paginate());
    }
}
