<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Gateapp\Models\Resident;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Gateapp\Models\Paymentrequest;
use Vtlabs\Core\Http\Controllers\Controller;
use Illuminate\Validation\ValidationException;
use Vtlabs\Gateapp\Filters\PaymentrequestFilter;
use Vtlabs\Gateapp\Http\Resources\PaymentrequestResource;

class PaymentrequestController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'flat_id' => 'required'
        ]);

        $paymentrequests = Paymentrequest::filter($request->all(), PaymentrequestFilter::class);

        return PaymentrequestResource::collection($paymentrequests->paginate());
    }

    public function createPayment(Paymentrequest $paymentrequest, Request $request)
    {
        $request->validate([
            'payment_method_slug' => 'required|exists:payment_methods,slug',
            'flat_id' => 'required'
        ]);

        if($paymentrequest->payment) {
            throw ValidationException::withMessages([
                'payment' => 'Already created'
            ]);
        }

        $resident = Resident::findByUser(Auth::id());

        $resident->createPayment($paymentrequest, $paymentrequest->amount, $request->payment_method_slug);

        return new PaymentrequestResource($paymentrequest->refresh());
    }
}
