<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Gateapp\Models\Flat;
use Vtlabs\Gateapp\Filters\FlatFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Http\Resources\Admin\FlatAdminResource;

class FlatController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'pagination' => 'sometimes|boolean',
            'title' => 'sometimes|string'
        ]);

        $flats = Flat::filter($request->all(), FlatFilter::class);

        if ($request->pagination == '0') {
            $flats = $flats->get();
        } else {
            $flats = $flats->paginate();
        }

        return FlatAdminResource::collection($flats);
    }
}
