<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Gateapp\Models\Project;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Gateapp\Models\Visitorlog;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Filters\VisitorlogFilter;
use Vtlabs\Gateapp\Http\Resources\Admin\VisitorlogAdminResource;

class VisitorlogController extends Controller
{
    public function index(Request $request)
    {
        $visitorlogs = Visitorlog::filter($request->all(), VisitorlogFilter::class)->latest()->paginate();

        $projectId = Project::permissionedProject();
        if($projectId) {
            $visitorlogs = $visitorlogs->where('id', $projectId);
        }

        return VisitorlogAdminResource::collection($visitorlogs);
    }

    public function show(Visitorlog $visitorlog)
    {
        return new VisitorlogAdminResource($visitorlog);
    }

    public function update(Request $request, Visitorlog $visitorlog)
    {
        $request->validate([
            'status' => 'required'
        ]);

        $visitorlog->setStatus($request->status);
        $visitorlog->save();

        return new VisitorlogAdminResource($visitorlog);
    }

    public function destroy(Visitorlog $visitorlog)
    {
        Gate::authorize('delete');

        $visitorlog->delete();

        return response()->json([], 204);
    }
}
