<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Gateapp\Models\Project;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Gateapp\Models\Servicebooking;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Filters\ServicebookingFilter;
use Vtlabs\Gateapp\Http\Resources\Admin\ServicebookingAdminResource;

class ServicebookingController extends Controller
{
    public function index(Request $request)
    {
        $servicebookings = Servicebooking::filter($request->all(), ServicebookingFilter::class)->paginate();

        $projectId = Project::permissionedProject();
        if($projectId) {
            $servicebookings = $servicebookings->where('id', $projectId);
        }

        return ServicebookingAdminResource::collection($servicebookings);
    }

    public function show(Servicebooking $servicebooking)
    {
        return new ServicebookingAdminResource($servicebooking);
    }

    public function update(Request $request, Servicebooking $servicebooking)
    {
        $request->validate([
            'status' => 'required'
        ]);

        $servicebooking->setStatus($request->status);
        $servicebooking->save();

        return new ServicebookingAdminResource($servicebooking);
    }

    public function destroy(Servicebooking $servicebooking)
    {
        Gate::authorize('delete');
        
        $servicebooking->delete();

        return response()->json([], 204);
    }
}
