<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Gateapp\Models\Flat;
use Vtlabs\Gateapp\Models\Project;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Gateapp\Filters\FlatFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Http\Resources\Admin\FlatAdminResource;

class FlatController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'pagination' => 'sometimes|boolean',
            'title' => 'sometimes|string'
        ]);

        $flats = Flat::filter($request->all(), FlatFilter::class);

        $projectId = Project::permissionedProject();
        if($projectId) {
            $flats = $flats->where('project_id', $projectId);
        }

        if ($request->pagination == '0') {
            $flats = $flats->get();
        } else {
            $flats = $flats->paginate();
        }

        return FlatAdminResource::collection($flats);
    }

    public function show(Flat $flat)
    {
        return new FlatAdminResource($flat);
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'meta' => 'sometimes|json|nullable',
            'building_id' => 'required|exists:gateapp_buildings,id',
        ]);

        if ($request->meta) {
            request()->merge(['meta' => $request->meta ? json_decode($request->meta) : null]);
        }

        $flat = Flat::create($request->all());

        return new FlatAdminResource($flat);
    }

    public function update(Request $request, Flat $flat)
    {
        $request->validate([
            'title' => 'required',
            'meta' => 'sometimes|json|nullable',
            'building_id' => 'required|exists:gateapp_buildings,id',
        ]);

        if ($request->meta) {
            request()->merge(['meta' => $request->meta ? json_decode($request->meta) : null]);
        }

        $flat->fill($request->all());
        $flat->save();

        return new FlatAdminResource($flat);
    }

    public function destroy(Flat $flat)
    {
        Gate::authorize('delete');
        
        $flat->delete();

        return response()->json([], 204);
    }
}
