<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Gateapp\Models\Project;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Gateapp\Models\Complaint;
use Vtlabs\Gateapp\Filters\ComplaintFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Http\Resources\Admin\ComplaintAdminResource;

class ComplaintController extends Controller
{
    public function index(Request $request)
    {
        $complaints = Complaint::filter($request->all(), ComplaintFilter::class)->paginate();

        $projectId = Project::permissionedProject();
        if($projectId) {
            $complaints = $complaints->where('project_id', $projectId);
        }

        return ComplaintAdminResource::collection($complaints);
    }

    public function show(Complaint $complaint)
    {
        return new ComplaintAdminResource($complaint);
    }

    public function update(Request $request, Complaint $complaint)
    {
        $request->validate([
            'status' => 'required'
        ]);

        $complaint->setStatus($request->status);
        $complaint->save();

        return new ComplaintAdminResource($complaint);
    }

    public function destroy(Complaint $complaint)
    {
        Gate::authorize('delete');
        
        $complaint->delete();

        return response()->json([], 204);
    }
}
