<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Gateapp\Models\Amenity;
use Vtlabs\Gateapp\Models\Project;
use Illuminate\Support\Facades\Log;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Core\Models\AdminPermission;
use Vtlabs\Gateapp\Filters\AmenityFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Http\Resources\Admin\AmenityAdminResource;

class AmenityController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'pagination' => 'sometimes|boolean',
            'title' => 'sometimes|string'
        ]);

        $amenitys = Amenity::filter($request->all(), AmenityFilter::class);

        $projectId = Project::permissionedProject();
        if($projectId) {
            $amenitys = $amenitys->where('project_id', $projectId);
        }

        if ($request->pagination == '0') {
            $amenitys = $amenitys->get();
        } else {
            $amenitys = $amenitys->paginate();
        }

        return AmenityAdminResource::collection($amenitys);
    }

    public function show(Amenity $amenity)
    {
        return new AmenityAdminResource($amenity);
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
            'fee' => 'required',
            'capacity' => 'required',
            'booking_capacity' => 'required',
            'advance_booking_days' => 'required',
            'max_days_per_flat' => 'required',
            'meta' => 'sometimes|json|nullable',
            'project_id' => 'required|exists:gateapp_projects,id'
        ]);

        if ($request->meta) {
            request()->merge(['meta' => $request->meta ? json_decode($request->meta) : null]);
        }

        $amenity = Amenity::create($request->all());

        return new AmenityAdminResource($amenity);
    }

    public function update(Request $request, Amenity $amenity)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
            'fee' => 'required',
            'capacity' => 'required',
            'booking_capacity' => 'required',
            'advance_booking_days' => 'required',
            'max_days_per_flat' => 'required',
            'meta' => 'sometimes|json|nullable',
            'project_id' => 'required|exists:gateapp_projects,id'
        ]);

        if ($request->meta) {
            request()->merge(['meta' => $request->meta ? json_decode($request->meta) : null]);
        }
        
        $amenity->fill($request->all());
        $amenity->save();

        return new AmenityAdminResource($amenity);
    }

    public function destroy(Amenity $amenity)
    {
        Gate::authorize('delete');
        
        $amenity->delete();

        return response()->json([], 204);
    }
}
