<?php

namespace Vtlabs\Gateapp\Filters;

use EloquentFilter\ModelFilter;

class ResidentFilter extends ModelFilter
{
    public function setup()
    {
    }

    public function user($id)
    {
        return $this->whereHas('user', function ($query) use ($id) {
            return $query->where('name', 'like', '%' . $id . '%')
                ->orWhere('mobile_number', 'like', '%' . $id . '%')
                ->orWhere('email', 'like', '%' . $id . '%')
                ->orWhere('id', $id);
        });
    }

    public function project($project)
    {
        return $this->where('project_id', $project);
    }

    public function building($id)
    {
        return $this->whereHas('building', function ($query) use ($id) {
            return $query->where('title', 'like', '%' . $id . '%')
                ->orWhere('id', $id);
        });
    }

    public function flat($id)
    {
        return $this->whereHas('flat', function ($query) use ($id) {
            return $query->where('title', 'like', '%' . $id . '%')
                ->orWhere('id', $id);
        });
    }

    // public function building($building)
    // {
    //     return $this->where('building_id', $building);
    // }
}
