<?php

namespace Vtlabs\Gateapp\Filters;

use EloquentFilter\ModelFilter;

class ComplaintFilter extends ModelFilter
{
    public function setup()
    {
    }

    public function project($project)
    {
        return $this->where('project_id', $project);
    }

    public function user($user)
    {
        return $this->where('user_id', $user);
    }

    public function flat($flat)
    {
        return $this->where('flat_id', $flat);
    }

    public function status($status)
    {
        return $this->currentStatus($status);
    }

    public function type($type) 
    {
        if($type == 'complaint') {
            return $this->whereIn('type', ['personal', 'community']);
        } else {
            return $this->where('type', $type);
        }
    }
}
