<?php
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Illuminate\Http\Request;

Route::middleware('api')->prefix('api')->name('api')->namespace('Vtlabs\Gateapp\Http\Controllers\Api')->group(function () {

    // admin api
    Route::namespace('Admin')->name('admin')->prefix('admin/gateapp')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::apiResource('projects', 'ProjectController');
            Route::apiResource('buildings', 'BuildingController');
            Route::apiResource('flats', 'FlatController');
            Route::apiResource('residents', 'ResidentController');
            Route::apiResource('complaints', 'ComplaintController')->except(['create']);
            Route::apiResource('announcements', 'AnnouncementController');
            Route::apiResource('amenities', 'AmenityController');
            Route::apiResource('appointments', 'AppointmentController')->except(['create']);
            Route::apiResource('guards', 'GuardController');
            Route::apiResource('visitorlogs', 'VisitorlogController')->except(['create']);
            Route::apiResource('paymentrequests', 'PaymentrequestController');
            Route::apiResource('servicebookings', 'ServicebookingController')->except(['create']);
        });
    });

    // app/web api
    Route::prefix('gateapp')->group(function () {

        Route::get('projects', 'ProjectController@index');
        Route::get('buildings', 'BuildingController@index');
        Route::get('flats', 'FlatController@index');

        Route::middleware('auth:api')->group(function () {
            Route::get('residents/myprofile', 'ResidentController@showMyProfile');
            Route::put('residents/myprofile', 'ResidentController@updateMyProfile');
            Route::get('residents/{resident}', 'ResidentController@show');
            
            Route::get('guards/myprofile', 'GuardController@showMyProfile');

            Route::apiResource('visitorlogs', 'VisitorlogController');

            Route::apiResource('complaints', 'ComplaintController');

            Route::get('announcements', 'AnnouncementController@index');
            Route::post('announcements/{announcement}/like', 'AnnouncementController@toggleLike');
            Route::post('announcements/{announcement}/poll', 'AnnouncementController@submitPoll');

            Route::get('paymentrequests', 'PaymentrequestController@index');
            Route::post('paymentrequests/{paymentrequest}/create-payment', 'PaymentrequestController@createPayment');

            Route::get('amenities', 'AmenityController@index');

            Route::get('appointments', 'AppointmentController@index');
            Route::post('appointments/{amenity}', 'AppointmentController@store');
            Route::put('appointments/{appointment}', 'AppointmentController@update');

            Route::get('servicebookings', 'ServicebookingController@index');
            Route::post('servicebookings', 'ServicebookingController@store');

            Route::get('projects/{project}/directory', 'ProjectController@directory');
        });
    });
});
