<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gateapp_projects', function (Blueprint $table) {
            $table->increments('id');

            $table->string('title');
            $table->string('address');
            $table->string('latitude');
            $table->string('longitude');
            $table->json('meta')->nullable();

            $table->integer('city_id')->unsigned();
            $table->foreign('city_id')->references('id')->on('categories')->onDelete('cascade');

            $table->timestamps();
        });

        Schema::create('gateapp_buildings', function (Blueprint $table) {
            $table->increments('id');

            $table->string('title');
            $table->json('meta')->nullable();

            $table->integer('project_id')->unsigned();
            $table->foreign('project_id')->references('id')->on('gateapp_projects')->onDelete('cascade');

            $table->timestamps();
        });

        Schema::create('gateapp_flats', function (Blueprint $table) {
            $table->increments('id');

            $table->string('title');
            $table->json('meta')->nullable();

            $table->integer('building_id')->unsigned();
            $table->foreign('building_id')->references('id')->on('gateapp_buildings')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('gateapp_buildings', function (Blueprint $table) {
            $table->dropForeign(['city_id']);
        });
        Schema::dropIfExists('gateapp_buildings');

        Schema::table('gateapp_projects', function (Blueprint $table) {
            $table->dropForeign(['city_id']);
        });
        Schema::dropIfExists('gateapp_projects');
    }
}
