<?php

namespace Vtlabs\Fantasysport\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;

class TeamPlayer extends Model
{
    use Filterable;

    protected $table = 'fsport_team_players';

    protected $guarded = [];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function fixturePlayer()
    {
        return $this->belongsTo(ApiFootballFixturePlayer::class, 'fixture_player_id');
    }
}
