<?php

namespace Vtlabs\Fantasysport\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class Team extends Model
{
    use Filterable;

    protected $table = 'fsport_teams';

    protected $guarded = [];

    public function players()
    {
        return $this->hasMany(TeamPlayer::class, 'team_id');
    }

    public function fixture()
    {
        return $this->belongsTo(ApiFootballFixture::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
