<?php

namespace Vtlabs\Fantasysport\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Fantasysport\Models\Contest;

class ContestWinning extends Model
{
    use Filterable;

    protected $table = 'fsport_contest_winnings';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
        'rank_from' => 'integer',
        'rank_to' => 'integer',
        'amount' => 'float'
    ];

    public function contest()
    {
        return $this->belongsTo(Contest::class);
    }
}
