<?php

namespace Vtlabs\Fantasysport\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Fantasysport\Models\ContestTeam;
use Vtlabs\Fantasysport\Models\ContestWinning;
use Vtlabs\Fantasysport\Models\ApiFootballFixture;

class Contest extends Model
{
    use Filterable;

    protected $table = 'fsport_contests';

    protected $guarded = [];

    public function fixture()
    {
        return $this->belongsTo(ApiFootballFixture::class);
    }

    public function teams()
    {
        return $this->hasMany(ContestTeam::class);
    }

    public function winnings()
    {
        return $this->hasMany(ContestWinning::class)->orderBy('rank_from');
    }
}
