<?php

namespace Vtlabs\Fantasysport\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;

class ApiFootballLeague extends Model
{
    use Filterable;


    protected $table = 'fsport_apifootball_leagues';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
        'enabled' => 'integer'
    ];

    public function seasons()
    {
        return $this->hasMany(ApiFootballSeason::class, 'league_id');
    }
}
