<?php

namespace Vtlabs\Fantasysport\Listeners;

use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Fantasysport\Models\Userprofile;

class RoleAssignedListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  RoleAssigned $event
     * @return void
     */
    public function handle(RoleAssigned $event)
    {
        if (in_array('customer', $event->roles)) {
            if (!Userprofile::where('user_id', $event->user->id)->exists()) {
                Userprofile::create([
                    'user_id' => $event->user->id
                ]);
            }
        }

        return true;
    }
}
