<?php

namespace Vtlabs\Fantasysport\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Vtlabs\Fantasysport\Http\Resources\TeamShortResource;

class TeamResource extends TeamShortResource
{
    public function toArray($request)
    {
        return collect(parent::toArray($request))->merge([
            'fixture_id' => $this->fixture_id,
            'fixture' => new ApiFootballFixtureResource($this->fixture),
            'players' => TeamPlayerResource::collection($this->players)
        ]);
    }
}
