<?php

namespace Vtlabs\Fantasysport\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Fantasysport\Http\Resources\ApiFootballFixturePlayerResource;

class TeamPlayerResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'meta' => $this->meta,
            'fixture_id' => $this->fixture_id,
            'fixture_player_id' => $this->fixture_player_id,
            'fixture_player' => new ApiFootballFixturePlayerResource($this->fixturePlayer),
            'remote_player_id' => $this->remote_player_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
