<?php

namespace Vtlabs\Fantasysport\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PlayerFixtureHistoryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'remote_team_id' => $this->remote_team_id,
            'remote_player_id' => $this->remote_player_id,
            'name' => $this->name,
            'number' => $this->number,
            'pos' => $this->pos,
            'grid' => $this->grid,
            'points' => $this->points,
            'credits' => $this->credits,
            'fixture_id' => $this->fixture_id,
            'fixture' => new ApiFootballFixtureResource($this->fixture)
        ];
    }
}
