<?php

namespace Vtlabs\Fantasysport\Http\Resources;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class ContestResource extends JsonResource
{
    public function toArray($request)
    {
        $firstRankWinning = $this->winnings->first();
        return [
            'id' => $this->id,
            'winner_percentage' => $this->winner_percentage,
            'spots' => $this->spots,
            'entry' => $this->entry,
            'entry_amount' => $this->entry_amount,
            'name' => $this->name,
            'meta' => $this->meta,
            'fixture_id' => $this->fixture_id,
            'fixture' => $this->fixture,
            'teams_count' => $this->teams->count(),
            'my_teams_count' => Auth::id() ? $this->teams()->whereHas('team', function($query){ $query->where('user_id', Auth::id()); })->count() : 0,
            'spots_left' => $this->spots - $this->teams->count(),
            'first_prize' => $firstRankWinning ? $firstRankWinning->amount : 0
        ];
    }
}
