<?php

namespace Vtlabs\Fantasysport\Http\Resources;

use Vtlabs\Fantasysport\Models\Team;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Fantasysport\Http\Resources\TeamShortResource;

class ContestLeaderboardResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'team_id' => $this->team_id,
            'points' => $this->points,
            'leaderboard_rank' => $this->leaderboard_rank,
            'team' => new TeamShortResource(Team::find($this->team_id))
        ];
    }
}
