<?php

namespace Vtlabs\Fantasysport\Http\Resources;

use Illuminate\Support\Facades\Auth;
use Vtlabs\Fantasysport\Models\Team;
use Vtlabs\Fantasysport\Models\ContestTeam;
use Illuminate\Http\Resources\Json\JsonResource;

class ApiFootballFixtureResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'remote_id' => $this->remote_id,
            'timezone' => $this->timezone,
            'date' => $this->date,
            'venue_name' => $this->venue_name,
            'venue_city' => $this->venue_city,
            'status' => $this->status,
            'status_long' => $this->status_long,
            'remote_league_id' => $this->remote_league_id,
            'league_name' => $this->league_name,
            'league_country' => $this->league_country,
            'league_logo' => $this->league_logo,
            'league_flag' => $this->league_flag,
            'season' => $this->season,
            'round' => $this->round,
            'remote_home_team_id' => $this->remote_home_team_id,
            'home_team_name' => $this->home_team_name,
            'home_team_logo' => $this->home_team_logo,
            'home_team_formation' => $this->home_team_formation,
            'remote_away_team_id' => $this->remote_away_team_id,
            'away_team_name' => $this->away_team_name,
            'away_team_logo' => $this->away_team_logo,
            'away_team_formation' => $this->away_team_formation,
            'enabled' => $this->enabled,
            'meta' => $this->meta,
            'my_teams' => Team::where('user_id', Auth::id())->where('fixture_id', $this->id)->count(),
            'my_contests' => ContestTeam::whereIn('team_id',Team::where('user_id', Auth::id())->where('fixture_id', $this->id)->pluck('id')->toArray())->count(),
        ];
    }
}
