<?php

namespace Vtlabs\Fantasysport\Http\Resources;

use Vtlabs\Fantasysport\Models\Team;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Fantasysport\Http\Resources\ApiFootballPlayerResource;
use Vtlabs\Fantasysport\Models\TeamPlayer;

class ApiFootballFixturePlayerResource extends JsonResource
{
    public function toArray($request)
    {
        $totalTeams = Team::where('fixture_id', $this->fixture_id)->count();
        $teamSelectedCurrentPlayer = TeamPlayer::where('fixture_id', $this->fixture_id)->where('fixture_player_id', $this->id)->count();

        return [
            'id' => $this->id,
            'remote_team_id' => $this->remote_team_id,
            'remote_player_id' => $this->remote_player_id,
            'name' => $this->name,
            'number' => $this->number,
            'pos' => $this->pos,
            'grid' => $this->grid,
            'points' => $this->points,
            'credits' => $this->credits,
            'fixture_id' => $this->fixture_id,
            'player' => new ApiFootballPlayerResource($this->player),
            'selected_percentage' => $totalTeams > 0 ? ($teamSelectedCurrentPlayer*100) / $totalTeams : 0
        ];
    }
}
