<?php

namespace Vtlabs\Fantasysport\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Vtlabs\Fantasysport\Models\Userprofile;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Fantasysport\Http\Resources\UserprofileResource;
use Vtlabs\Fantasysport\Http\Resources\UserLeaderboardResource;

class UserprofileController extends Controller
{
    public function leaderboard(Request $request)
    {
        $leaderboard = DB::select('SELECT u.name, u.mobile_number, p.user_id,p.points, FIND_IN_SET( points, (SELECT GROUP_CONCAT( DISTINCT points ORDER BY points DESC ) FROM fsport_user_profiles) ) AS leaderboard_rank FROM fsport_user_profiles p left join users u on p.user_id=u.id;');

        return UserLeaderboardResource::collection($leaderboard);
    }

    public function show()
    {
        $user = auth()->user();

        $userprofile = Userprofile::where('user_id', $user->id)->first();

        return new UserprofileResource($userprofile);
    }
}
