<?php

namespace Vtlabs\Fantasysport\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Fantasysport\Models\Team;
use Vtlabs\Fantasysport\Models\TeamPlayer;
use Vtlabs\Fantasysport\Filters\TeamFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Fantasysport\Http\Resources\TeamResource;
use Vtlabs\Fantasysport\Models\ApiFootballFixturePlayer;

class TeamController extends Controller
{

    public function __construct()
    {
        if (array_key_exists('HTTP_AUTHORIZATION', $_SERVER) && $_SERVER['HTTP_AUTHORIZATION']) {
            $this->middleware('auth:api');
        }
    }
    
    public function index(Request $request)
    {
        $request->validate([]);

        $teams = Team::filter($request->all(), TeamFilter::class);

        return TeamResource::collection($teams->paginate());
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'fixture_id' => 'required',
            'players' => 'required|array',
            'players.*.id' => 'required',
            'players.*.type' => 'required|in:player,captain,vicecaptain'
        ]);

        request()->merge(['user_id' => Auth::id()]);

        $team = Team::create($request->only('name', 'fixture_id', 'user_id'));

        // players
        $teamPlayers = array();
        foreach ($request->players as $player) {
            $fixturePlayer = ApiFootballFixturePlayer::find($player['id']);
            array_push($teamPlayers, new TeamPlayer(['type' => $player['type'], 'fixture_id' => $request->fixture_id, 'fixture_player_id' => $player['id'], 'remote_player_id' => $fixturePlayer->remote_player_id]));
        }

        $team->players()->saveMany($teamPlayers);

        return new TeamResource($team);
    }

    public function update(Team $team, Request $request)
    {
        $request->validate([
            'name' => 'required',
            'fixture_id' => 'required',
            'players' => 'required|array',
            'players.*.id' => 'required',
            'players.*.type' => 'required|in:player,captain,vicecaptain'
        ]);

        $team = $team->fill($request->only('name', 'fixture_id'));
        $team->save();

        // players
        $teamPlayers = array();
        foreach ($request->players as $player) {
            $fixturePlayer = ApiFootballFixturePlayer::find($player['id']);
            array_push($teamPlayers, new TeamPlayer(['type' => $player['type'], 'fixture_id' => $request->fixture_id, 'fixture_player_id' => $player['id'], 'remote_player_id' => $fixturePlayer->remote_player_id]));
        }

        $team->players()->delete();
        $team->players()->saveMany($teamPlayers);

        return new TeamResource($team);
    }
}
