<?php

namespace Vtlabs\Fantasysport\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Vtlabs\Fantasysport\Models\Contest;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Fantasysport\Filters\FixtureFilter;
use Vtlabs\Fantasysport\Models\ApiFootballFixture;
use Vtlabs\Fantasysport\Filters\FixturePlayerFilter;
use Vtlabs\Fantasysport\Http\Resources\ContestResource;
use Vtlabs\Fantasysport\Models\ApiFootballFixturePlayer;
use Vtlabs\Fantasysport\Http\Resources\ApiFootballFixtureResource;
use Vtlabs\Fantasysport\Http\Resources\PlayerFixtureHistoryResource;
use Vtlabs\Fantasysport\Http\Resources\ApiFootballFixturePlayerResource;

class FixtureController extends Controller
{
    public function __construct()
    {
        if (array_key_exists('HTTP_AUTHORIZATION', $_SERVER) && $_SERVER['HTTP_AUTHORIZATION']) {
            $this->middleware('auth:api');
        }
    }

    public function index(Request $request)
    {
        $request->validate([]);

        $fixtures = ApiFootballFixture::filter($request->all(), FixtureFilter::class);

        $fixtures = $fixtures->orderBy('date');

        return ApiFootballFixtureResource::collection($fixtures->paginate());
    }

    public function players(ApiFootballFixture $fixture, Request $request)
    {
        $request->validate([]);

        $request->merge(['fixture_id' => $fixture->id]);

        $players = ApiFootballFixturePlayer::filter($request->all(), FixturePlayerFilter::class);

        return ApiFootballFixturePlayerResource::collection($players->get());
    }

    public function contests(ApiFootballFixture $fixture, Request $request)
    {
        $request->validate([]);

        $request->merge(['fixture_id' => $fixture->id]);

        $contests = Contest::filter($request->all(), ContestFilter::class);

        return ContestResource::collection($contests->paginate());
    }

    public function playerFixtureHistory($remotePlayerId, Request $request)
    {
        $request->validate([]);

        $request->merge(['remote_player' => $remotePlayerId]);

        $fixtures = ApiFootballFixturePlayer::filter($request->all(), FixturePlayerFilter::class);

        return PlayerFixtureHistoryResource::collection($fixtures->get());
    }
}
