<?php

namespace Vtlabs\Fantasysport\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Vtlabs\Fantasysport\Models\Userprofile;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Fantasysport\Filters\UserprofileFilter;
use Vtlabs\Fantasysport\Http\Resources\Admin\UserprofileAdminResource;

class UserprofileController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([]);

        $userprofiles = Userprofile::filter($request->all(), UserprofileFilter::class);

        $userprofiles->orderByDesc('points');

        return UserprofileAdminResource::collection($userprofiles->paginate());
    }

    public function leaderboard(Request $request)
    {
        $leaderboard = DB::select('SELECT u.name, u.mobile_number, p.user_id,p.points, FIND_IN_SET( points, (SELECT GROUP_CONCAT( DISTINCT points ORDER BY points DESC ) FROM fsport_user_profiles) ) AS leaderboard_rank FROM fsport_user_profiles p left join users u on p.user_id=u.id;');

        return response()->json(['data' => $leaderboard]);
    }
}
