<?php

namespace Vtlabs\Fantasysport\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Fantasysport\Filters\LeagueFilter;
use Vtlabs\Fantasysport\Models\ApiFootballLeague;
use Vtlabs\Fantasysport\Http\Resources\Admin\ApiFootballLeagueAdminResource;

class LeagueController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([]);

        $leagues = ApiFootballLeague::filter($request->all(), LeagueFilter::class);

        $leagues = $leagues->orderByDesc('enabled');

        return ApiFootballLeagueAdminResource::collection($leagues->paginate());
    }

    public function show(ApiFootballLeague $league, Request $request)
    {
        return new ApiFootballLeagueAdminResource($league);
    }

    public function update(ApiFootballLeague $league, Request $request)
    {
        $request->validate([
            'enabled' => 'required|boolean'
        ]);

        $league->fill($request->only(['enabled']));
        $league->save();
        
        return new ApiFootballLeagueAdminResource($league);
    }
}
