<?php

namespace Vtlabs\Fantasysport\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Fantasysport\Filters\FixtureFilter;
use Vtlabs\Fantasysport\Models\ApiFootballFixture;
use Vtlabs\Fantasysport\Http\Resources\Admin\ApiFootballFixtureAdminResource;

class FixtureController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([]);

        $fixtures = ApiFootballFixture::filter($request->all(), FixtureFilter::class);

        if ($request->pagination == '0') {
            $fixtures = $fixtures->get();
        } else {
            $fixtures = $fixtures->paginate();
        }

        return ApiFootballFixtureAdminResource::collection($fixtures);
    }
}
