<?php

namespace Vtlabs\Fantasysport\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Fantasysport\Models\Contest;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Fantasysport\Filters\ContestFilter;
use Vtlabs\Fantasysport\Http\Resources\Admin\ContestAdminResource;

class ContestController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([]);

        $contests = Contest::filter($request->all(), ContestFilter::class);

        return ContestAdminResource::collection($contests->paginate());
    }

    public function show(Contest $contest, Request $request)
    {
        return new ContestAdminResource($contest);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'spots' => 'required',
            'winner_percentage' => 'required',
            'entry' => 'required',
            'entry_amount' => 'required',
            'meta' => 'sometimes',
            'is_prototype' => 'sometimes',
            'fixture_id' => 'sometimes|exists:fsport_apifootball_fixtures,id'
        ]);

        request()->merge(['meta' => $request->meta ? json_decode($request->meta) : null]);

        $contest = Contest::create($request->only(['name', 'spots', 'winner_percentage', 'entry', 'entry_amount', 'meta', 'is_prototype', 'fixture_id']));

        return new ContestAdminResource($contest);
    }

    public function update(Contest $contest, Request $request)
    {
        $request->validate([
            'name' => 'required',
            'spots' => 'required',
            'winner_percentage' => 'required',
            'entry' => 'required',
            'entry_amount' => 'required',
            'meta' => 'sometimes',
            'is_prototype' => 'sometimes',
            'fixture_id' => 'sometimes|exists:fsport_apifootball_fixtures,id'
        ]);

        request()->merge(['meta' => $request->meta ? json_decode($request->meta) : null]);

        $contest->fill($request->only(['name', 'spots', 'winner_percentage', 'entry', 'entry_amount', 'meta', 'is_prototype', 'fixture_id']));
        $contest->save();

        return new ContestAdminResource($contest);
    }

    public function destroy(Contest $contest)
    {
        Gate::authorize('delete');

        $contest->delete();

        return response()->json([], 200);
    }
}
