<?php

namespace Vtlabs\Fantasysport\Filters;

use Carbon\Carbon;
use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Fantasysport\Models\Team;

class FixtureFilter extends ModelFilter
{
    public function setup()
    {
    }

    public function upcoming($upcoming)
    {
        return $this->where('date', '>=', Carbon::now()->toDateString());
    }

    public function past($past)
    {
        return $this->where('date', '<=', Carbon::now()->toDateString());
    }

    public function myfixture($myfixture)
    {
        return $this->whereIn('id', Team::where('user_id', Auth::id())->pluck('fixture_id')->toArray());
    }
}
