<?php

namespace Vtlabs\Fantasysport\Filters;

use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\Auth;

class ContestFilter extends ModelFilter
{
    public function setup()
    {
    }

    public function isPrototype($isPrototype)
    {
        if ($isPrototype == '1') {
            return $this->where('is_prototype', 1);
        } else {
            return $this->where('is_prototype', 0);
        }
    }

    public function mycontests($mycontests)
    {
        return $this->whereHas('teams.team', function($query) {
            $query->where('user_id', Auth::id());
        });
    }

    public function fixture($fixture)
    {
        return $this->where('fixture_id', $fixture);
    }
}
