<?php
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Illuminate\Http\Request;

Route::middleware('api')->prefix('api')->name('api')->namespace('Vtlabs\Fantasysport\Http\Controllers\Api')->group(function () {

    // admin api
    Route::namespace('Admin')->name('admin')->prefix('admin/fantasysport')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::apiResource('leagues', 'LeagueController');
            Route::apiResource('contests', 'ContestController');
            Route::apiResource('fixtures', 'FixtureController');
            Route::get('userprofiles-leaderboard', 'UserprofileController@leaderboard');
            Route::apiResource('userprofiles', 'UserprofileController');
        });
    });

    // app/web api
    Route::prefix('fantasysport')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::post('teams', 'TeamController@store');
            Route::put('teams/{team}', 'TeamController@update');
            
            Route::post('contests/{contest}', 'ContestController@joinContest');

            Route::get('userprofiles', 'UserprofileController@show');
        });

        Route::get('fixtures', 'FixtureController@index');
        Route::get('fixtures/{fixture}/players', 'FixtureController@players');
        Route::get('players/fixture-history/{remotePlayerId}', 'FixtureController@playerFixtureHistory');

        Route::get('contests', 'ContestController@index');
        Route::get('contests/{contest}/winnings', 'ContestController@winnings');
        Route::get('contests/{contest}/leaderboard', 'ContestController@leaderboard');
        
        Route::get('teams', 'TeamController@index');

        Route::get('userprofiles/leaderboard', 'UserprofileController@leaderboard');
    });
});
