<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFsportContestWinningsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fsport_contest_winnings', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('rank_from')->unsigned();
            $table->integer('rank_to')->unsigned();
            $table->double('amount');

            $table->json('meta')->nullable();
            $table->timestamps();

            // contest
            $table->integer('contest_id')->unsigned()->nullable();
            $table->foreign('contest_id')->references('id')->on('fsport_contests')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fsport_contest_winnings');
    }
}
