<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFsportContestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fsport_contests', function (Blueprint $table) {
            $table->increments('id');
            $table->tinyInteger('winner_percentage')->unsigned();
            $table->smallInteger('spots')->unsigned();
            $table->enum('entry', ['single', 'multi']);
            $table->double('entry_amount');

            $table->boolean('is_prototype')->default(false);

            $table->string('name'); // name of the team by user
            $table->json('meta')->nullable();
            $table->timestamps();

            // fixture
            $table->integer('fixture_id')->unsigned()->nullable();
            $table->foreign('fixture_id')->references('id')->on('fsport_apifootball_fixtures')->onDelete('cascade');
        });

        // teams in contests
        Schema::create('fsport_contest_teams', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();

            // team
            $table->integer('team_id')->unsigned()->nullable();
            $table->foreign('team_id')->references('id')->on('fsport_teams')->onDelete('cascade');

            $table->integer('points')->unsigned()->default(0)->index(); // points accumulated by team in fixture, used for ranks and leaderboard, do not use points from  fsport_teams

            // contest
            $table->integer('contest_id')->unsigned()->nullable();
            $table->foreign('contest_id')->references('id')->on('fsport_contests')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('fsport_contest_teams', function (Blueprint $table) {
            $table->dropForeign(['team_id']);
            $table->dropForeign(['contest_id']);
        });
        Schema::dropIfExists('fsport_contest_teams');

        Schema::table('fsport_contests', function (Blueprint $table) {
            $table->dropForeign(['fixture_id']);
        });
        Schema::dropIfExists('fsport_contests');
    }
}
