<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFsportTeamsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // team created by user for the fixture
        Schema::create('fsport_teams', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name'); // name of the team by user
            $table->json('meta')->nullable();
            $table->timestamps();

            // do not use these points for contest leaderboard
            $table->integer('points')->unsigned()->default(0)->index(); // points accumulated by team in fixture, used for ranks and leaderboard

            // fixture
            $table->integer('fixture_id')->unsigned()->nullable();
            $table->foreign('fixture_id')->references('id')->on('fsport_apifootball_fixtures')->onDelete('cascade');

            // user
            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });

        // players in the team created by user for the fixture
        Schema::create('fsport_team_players', function (Blueprint $table) {
            $table->increments('id');
            $table->enum('type', ['player', 'captain', 'vicecaptain']);
            $table->json('meta')->nullable();
            $table->timestamps();

            // fixture
            $table->integer('fixture_id')->unsigned()->nullable();
            $table->foreign('fixture_id')->references('id')->on('fsport_apifootball_fixtures')->onDelete('cascade');

            // fixture player
            $table->integer('fixture_player_id')->unsigned()->nullable();
            $table->foreign('fixture_player_id')->references('id')->on('fsport_apifootball_fixture_players')->onDelete('cascade');

            // save remote player id of this player as well for further stats e.g number of teams selected this player in a fixture
            $table->integer('remote_player_id')->unsigned()->index();

            // user team this player is associated with
            $table->integer('team_id')->unsigned()->nullable();
            $table->foreign('team_id')->references('id')->on('fsport_teams')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('fsport_team_players', function (Blueprint $table) {
            $table->dropForeign(['fixture_id']);
            $table->dropForeign(['fixture_player_id']);
            $table->dropForeign(['team_id']);
        });
        Schema::dropIfExists('fsport_teams');

        Schema::table('fsport_teams', function (Blueprint $table) {
            $table->dropForeign(['fixture_id']);
            $table->dropForeign(['user_id']);
        });
        Schema::dropIfExists('fsport_teams');
    }
}
