<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFsportApifootballFixturesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fsport_apifootball_fixtures', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('remote_id')->unsigned()->index();

            $table->string('timezone', 50);
            $table->dateTimeTz('date');

            $table->string('venue_name', 100);
            $table->string('venue_city', 50);

            $table->string('status', 5);
            $table->string('status_long', 50);

            $table->integer('remote_league_id')->unsigned()->index();
            $table->string('league_name');
            $table->string('league_country');
            $table->string('league_logo');
            $table->string('league_flag');
            $table->string('season');
            $table->string('round');

            $table->integer('remote_home_team_id')->unsigned()->index();
            $table->string('home_team_name');
            $table->string('home_team_logo');
            $table->string('home_team_formation', 10)->nullable(); // this will be available once lineup is announced
            $table->integer('remote_away_team_id')->unsigned();
            $table->string('away_team_name');
            $table->string('away_team_logo');
            $table->string('away_team_formation', 10)->nullable(); // this will be available once lineup is announced

            $table->boolean('enabled')->default(false);
            $table->json('meta')->nullable();
            $table->timestamps();
        });

        Schema::create('fsport_apifootball_fixture_players', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('remote_team_id')->unsigned()->index();
            $table->integer('remote_player_id')->unsigned()->index();
            $table->string('name');
            $table->integer('number')->unsigned();
            $table->string('pos', 2);
            $table->string('grid', 5)->nullable();

            $table->integer('points')->unsigned()->default(0); // points accumulated by this player in this fixture
            $table->float('credits')->unsigned()->default(0); // credits assigned to this player in this fixture


            $table->integer('fixture_id')->unsigned()->nullable();
            $table->foreign('fixture_id')->references('id')->on('fsport_apifootball_fixtures')->onDelete('cascade');

            $table->timestamps();
        });

        Schema::create('fsport_apifootball_fixture_player_events', function (Blueprint $table) {
            $table->increments('id');

            $table->string('hash', 32);

            $table->integer('remote_player_id')->unsigned()->index();
            $table->string('type');
            $table->integer('points')->default(0); // points accumulated for this event


            $table->integer('fixture_id')->unsigned()->nullable();
            $table->foreign('fixture_id')->references('id')->on('fsport_apifootball_fixtures')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('fsport_apifootball_fixture_players', function (Blueprint $table) {
            $table->dropForeign(['fixture_id']);
        });
        Schema::dropIfExists('fsport_apifootball_fixture_players');

        Schema::dropIfExists('fsport_apifootball_fixtures');
    }
}
