<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFsportApifootballLeaguesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        // https://www.api-football.com/documentation-v3#operation/get-leagues
        
        Schema::create('fsport_apifootball_leagues', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('remote_id')->unsigned()->index();
            $table->string('name');
            $table->string('type', 10);
            $table->string('logo');
            $table->string('country_code', 5)->nullable();
            $table->string('country_name', 50)->nullable();
            $table->string('country_flag')->nullable();
            $table->boolean('enabled')->default(false);
            $table->json('meta')->nullable();
            $table->timestamps();
        });

        Schema::create('fsport_apifootball_league_seasons', function (Blueprint $table) {
            $table->increments('id');
            $table->string('year', 4);
            $table->date('start');
            $table->date('end');
            $table->boolean('coverage_fixtures_event');
            $table->boolean('coverage_fixtures_lineups');
            $table->boolean('coverage_fixtures_statistics_fixtures');
            $table->boolean('coverage_fixtures_statistics_players');
            $table->boolean('coverage_standings');
            $table->boolean('coverage_players');
            $table->boolean('coverage_top_scorers');
            $table->boolean('coverage_top_assists');
            $table->boolean('coverage_top_cards');
            $table->boolean('coverage_injuries');
            $table->boolean('coverage_predictions');
            $table->boolean('coverage_odds');
            $table->timestamps();

            $table->integer('league_id')->unsigned()->nullable();
            $table->foreign('league_id')->references('id')->on('fsport_apifootball_leagues')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('fsport_apifootball_league_seasons', function (Blueprint $table) {
            $table->dropForeign(['league_id']);
        });
        Schema::dropIfExists('fsport_apifootball_league_seasons');

        Schema::dropIfExists('fsport_apifootball_leagues');
    }
}
