<?php

namespace Vtlabs\Event\Models;

use EloquentFilter\Filterable;
use Rennokki\Rating\Traits\CanBeRated;
use Illuminate\Database\Eloquent\Model;
use Rennokki\Rating\Contracts\Rateable;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;
use ChristianKuri\LaravelFavorite\Traits\Favoriteable;

class Venue extends Model implements HasMedia, Rateable
{
    use Filterable,
        HasTranslations,
        Favoriteable,
        CoreHasMediaTrait,
        CanBeRated;

    protected $table = 'ev_venues';

    protected $guarded = [];

    protected $appends = ['mediaurls'];

    protected $casts = [
        'title' => 'array',
        'short_description' => 'array',
        'description' => 'array',
        'meta' => 'json',
        'latitude' => 'decimal:2',
        'longitude' => 'decimal:2',
    ];

    public $translatable = ['title', 'description', 'short_description'];

    public function getIsFavouriteAttribute()
    {
        return $this->isFavorited();
    }
}