<?php

namespace Vtlabs\Event\Models;

use Vtlabs\Event\Models\Seat;
use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;

class Auditorium extends Model implements HasMedia
{
    use Filterable,
        HasTranslations,
        CoreHasMediaTrait;

    protected $table = 'ev_auditoriums';

    protected $guarded = [];

    protected $appends = ['mediaurls'];

    protected $casts = [
        'title' => 'array',
        'meta' => 'json'
    ];

    public $translatable = ['title'];

    public function venue()
    {
        return $this->belongsTo(Venue::class);
    }

    public function seats()
    {
        return $this->hasMany(Seat::class);
    }
}