<?php

namespace Vtlabs\Event\Http\Resources;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Resources\Json\JsonResource;

class EventResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),
            'short_description' => $this->short_description,
            'short_description_translations' => $this->getTranslations('short_description'),
            
            'date' => $this->date,
            'time_from' => $this->time_from,
            'time_to' => $this->time_to,

            'area' => $this->area,
            'address' => $this->address,
            'longitude' => $this->longitude,
            'latitude' => $this->latitude,
            'distance' => $this->distance ?? "0.00",

            'mediaurls' => $this->getMediaUrlsAttribute(),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            
            'auditorium_id' => $this->auditorium_id,
            'auditorium' => new AuditoriumResource($this->auditorium),
            
            'artists' => EventArtistResource::collection($this->artists),
            'event_categories' => EventCategoryResource::collection($this->eventCategories),

            'favourite_count' => $this->favoritesCount,
            'is_favourite' => $this->isFavourite ? 1 : 0,

            'seats_booked' => DB::table('ev_events as e')->where('e.id', $this->id)->join('ev_orders as o', 'e.id', '=', 'o.event_id')->join('ev_order_seats as s', 's.order_id', '=', 'o.id')->count()
        ];
    }
}
