<?php

namespace Vtlabs\Event\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Event\Models\Event;
use Vtlabs\Event\Models\Artist;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Event\Models\OrderSeat;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Event\Filters\EventFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Event\Http\Resources\SeatResource;
use Vtlabs\Event\Http\Resources\EventResource;
use Vtlabs\Event\Http\Resources\ArtistResource;
use Vtlabs\Category\Http\Resources\CategoryResource;

/**
 * @group Event
 *
 * APIs for event requests
 */
class ArtistController extends Controller
{
    public function __construct()
    {
        if (array_key_exists('HTTP_AUTHORIZATION', $_SERVER)) {
            $this->middleware('auth:api');
        }
    }

    public function show(Artist $artist, Request $request)
    {
        return new ArtistResource($artist);
    }

    public function toggleFavourite(Artist $artist, Request $request)
    {
        $artist->toggleFavorite();

        return response()->json((object)[]);
    }

    public function favourites(Request $request)
    {
        $artistList = Auth::user()->favorite(Artist::class)->flatten();

        return ArtistResource::collection($artistList);
    }
}
