<?php

namespace Vtlabs\Event\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Event\Models\EventOrder;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Event\Filters\EventOrderFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Event\Http\Resources\Admin\EventOrderAdminResource;

class EventOrderController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
        ]);

        $eventorders = EventOrder::filter($request->all(), EventOrderFilter::class)->ordered();

        return EventOrderAdminResource::collection($eventorders->paginate());
    }

    public function show(EventOrder $order)
    {
        return new EventOrderAdminResource($order);
    }

    public function destroy(EventOrder $order)
    {
        Gate::authorize('delete');

        $order->delete();

        return response()->json([], 200);
    }
}
