<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEventsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ev_events', function (Blueprint $table) {
            $table->increments('id');
            $table->json('title');
            $table->json('description');
            $table->json('short_description');
            $table->json('meta')->nullable();
            
            $table->date('date');
            $table->time('time_from');
            $table->time('time_to');

            // address
            $table->string('area')->nullable();
            $table->string('address')->nullable();
            $table->decimal('longitude', 15, 7)->default(0.0);
            $table->decimal('latitude', 15, 7)->default(0.0);

            $table->integer('auditorium_id')->unsigned()->nullable();
            $table->foreign('auditorium_id')->references('id')->on('ev_auditoriums')->onDelete('cascade');
            
            $table->timestamps();
        });

        Schema::create('ev_event_categories', function (Blueprint $table) {
            $table->integer('event_id')->unsigned();
            $table->integer('category_id')->unsigned();
            $table->double('price', 8, 2)->default(0);
            $table->foreign('event_id')->references('id')->on('ev_events')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
        });

        Schema::create('ev_event_artists', function (Blueprint $table) {
            $table->integer('event_id')->unsigned();
            $table->integer('artist_id')->unsigned();
            $table->foreign('event_id')->references('id')->on('ev_events')->onDelete('cascade');
            $table->foreign('artist_id')->references('id')->on('ev_artists')->onDelete('cascade');
            $table->time('time_from');
            $table->time('time_to');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ev_event_categories', function (Blueprint $table) {
            $table->dropForeign(['event_id']);
            $table->dropForeign(['category_id']);
        });

        Schema::table('ev_event_artists', function (Blueprint $table) {
            $table->dropForeign(['event_id']);
            $table->dropForeign(['artist_id']);
        });

        Schema::dropIfExists('ev_events');
    }
}
