<?php

namespace Vtlabs\Event\Models;

use EloquentFilter\Filterable;
use Vtlabs\Event\Models\Auditorium;
use Vtlabs\Category\Models\Category;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Seat extends Model
{
    use Filterable,
        HasTranslations;

    protected $table = 'ev_seats';

    protected $guarded = [];

    protected $casts = [
        'title' => 'array',
        'meta' => 'json'
    ];

    public $translatable = ['title'];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}