<?php

namespace Vtlabs\Event\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Partner extends Model implements HasMedia
{
    use Filterable,
        HasTranslations,
        CoreHasMediaTrait;

    protected $table = 'ev_partners';

    protected $guarded = [];

    protected $appends = ['mediaurls'];

    protected $casts = [
        'title' => 'array',
        'description' => 'array',
        'meta' => 'json'
    ];

    public $translatable = ['title', 'description'];

    public function coupons(): HasMany 
    {
        return $this->hasMany(Coupon::class);
    }
}
