<?php

namespace Vtlabs\Event\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Vtlabs\Core\Models\User\User;

class Featureresponse extends Model
{
    use Filterable;

    protected $table = 'ev_featureresponses';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json'
    ];

    protected $with = ['feature'];

    public function feature(): BelongsTo
    {
        return $this->belongsTo(Feature::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
