<?php

namespace Vtlabs\Event\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Feature extends Model implements HasMedia
{
    use Filterable,
        HasTranslations,
        CoreHasMediaTrait;

    protected $table = 'ev_features';

    protected $guarded = [];

    protected $appends = ['mediaurls'];

    protected $casts = [
        'title' => 'array',
        'description' => 'array',
        'meta' => 'json',
        'sort_order' => 'integer'
    ];

    public $translatable = ['title', 'description'];

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }

    public function responses(): HasMany
    {
        return $this->hasMany(Featureresponse::class);
    }
}
